model Ex3_25
//Basis 100 moles of feed//
parameter Real N(unit="moles")=100 "No of moles of reactant";
parameter Real N0(unit="moles")=200"No of moles of product";
parameter Real k(unit="sec^(-1)")=0.1 "Rate constant";
parameter Real XA(unit="No units")=0.80 "Conversion";
Real EA(unit="No units") "Fractional change in volume";
Real tow(unit="sec") "Space time";
equation
EA=(N0-N)/N;
//For first order reaction plug flow performance is given by//
tow=(-(1+EA)*log(1-XA)-(EA*XA))/k;
end Ex3_25;
