model Ex3_26
parameter Real k1(unit="lit/(mol.min)")=7 "Rate constant of forward reaction";
parameter Real k2(unit="lit/(mol.min)")=3 "Rate constant of backward reaction";
parameter Real Ca0(unit="mol of A/lit")=1.4 "Concentration of A in mixed feed stream";
parameter Real Cb0(unit="mol of B/lit")=0.8 "Concentration of B in mixed feed stream";
parameter Real Cp0(unit="mol of P/lit")=0 "Concentration of P in feed stream";
parameter Real XB(unit="No units")=0.75 "Conversion of B";
parameter Real V(unit="lit")=120 "Volume of reactor";
Real Ca1(unit="mol/lit") "Concentration of A";
Real Cb1(unit="mol/lit") "Concentration of B";
Real BReacted(unit="mol/lit") "Amount of B reacted";
Real Ca(unit"mol/lit") "Amount of A unreacted";
Real Cb(unit"mol/lit") "Amount of B unreacted";
Real Cp(unit"mol/lit") "Amount of P formed";
Real rate(unit="mol/(lit.min)") "Rate of reaction";
Real v(unit="lit/min") "Volumetric flow rate";
equation
//Since the two streams are fed in equal volume, assuming each stram of 1lit and the mixed stream is 2l//
Ca1=Ca0/2;
Cb1=Cb0/2;
//Cp0=Cq0=0//
//Since the concentration of A is more the limiting component is B//
BReacted=Cb1*XB;
Ca=Ca1-BReacted;
Cb=Cb1-BReacted;
Cp=BReacted;
//Cp=Cq//
rate=(k1*Ca*Cb)-(k2*Cp*Cp);
//For constant density and mixed flow reactor//
v=(V*(rate)/(Ca1-Ca));
//For introduction of two streams in equal volume the flow rate must be equally divided//
end Ex3_26;
