model Ex3_3
parameter Real Ca0(unit="mol/lit")=100 "Initial concentration of A";
parameter Real Cb0(unit="mol/lit")=200 "Initial concentration of B";
parameter Real CR(unit="mol/lit")=500 " Concentration of R";
parameter Real Ca(unit="mol/lit")=20 "Concentration of A";
parameter Real T(unit="K")=400 "Exit Temperature";
parameter Real T0(unit="K")=1000 "Initial Temperature";
parameter Real P(unit="atm")=4"Initial pressure";
parameter Real P0(unit="atm")=5"Initial pressure";
parameter Real a(unit="No units")=1 "Stoichiometric coefficient of A";
parameter Real b(unit="No units")=1 "Stoichiometric coefficient of B";
Real V0(unit="lit") "Volume of the system when XA=0";
Real V(unit="lit") "Volume of the system when XA=1";
Real EA(unit="No units") "Fractional change in volume wrt A";
Real Cb(unit="mol/lit") "Concentration of B";
Real XA(unit="No units") "Conversion";
Real XB(unit="No units") "Conversion";
equation
V0=Ca0+Cb0;
V=Ca0+CR;
EA=((V-V0)/V0);
XA=(1-((Ca/Ca0)*((T*P0)/(T0*P))))/((1)+EA*(Ca/Ca0)*(T*P0)/(T0*P));
Cb=Ca0*((Cb0/Ca0)-(b/a)*XA)*((T0*P))/((1+EA*XA)*(P0*T));
XB=((Cb0/Ca0)-((Cb/Ca0)*(T*P0)/(T0*P)))/((b/a)+(EA*(Cb/Ca0))*(T*P0)/(T0*P));
//The values of XA and XB differs from that in book//
//The values given by the book is wrong//
end Ex3_3;
