model Ex3_32
parameter Real M0(unit="kg/min")=170 "Production rate of ethylene glycol";
parameter Real MW(unit="kg/kmol")=62 "Molecular weight of ethylene glycol";
parameter Real XA(unit="No units")=0.80 "Conversion";
parameter Real Ca0(unit="kmol/hr")=16 "Concentration of A in the stream leaving the reactor";
parameter Real k(unit="min^-1")=0.311 "Rate constant";
Real m0(unit="kmol/min") "Molar production rate";
Real Fa0(unit="kmol/hr") "Molar flow rate of A to reactor";
Real vA0(unit="m^3/min") "Volumetric flow rate of A entering the stream";
Real v0(unit="m^3/min") "Volumetric flow rate of A entering the stream";
Real V(unit="lit") "Volume of the reactor";
equation
m0=M0/MW;
//From the reaction stoichiometry 1kmol of A= 1Kmol of C//
Fa0=m0/XA;
vA0=Fa0/Ca0;
//From the statement equal volumetric flowrate of both streams are fed//
v0=2*vA0;
V=((v0*XA)/(k*(1-XA)))*1000;
end Ex3_32;
