model Ex3_33
parameter Real[4] Fa0(unit="g/hr")={130,50,21,10.8} "Flow rate of acetone";
parameter Real[4]XA(unit="No units")={0.05,0.13,0.24,0.35} "Conversion of acetone";
parameter Real MW(unit="g/gmol")=58 "Molecular weight of acetone";
parameter Real D(unit="cm")=3.3 "Diameter of the reactor";
parameter Real L(unit="cm")=80 "Length of the reactor";
parameter Real R(unit="lit.atm/(mol.K)")=0.08206 "Gas constant";
parameter Real T(unit="K")=793 "Temperature";
parameter Real pA0(unit="atm")=1 "Pressure";
//Basis 100 moles of feed//
parameter Real N0(unit="mol")=200 "Moles of product";
parameter Real N(unit="mol")=100 "Moles of product";
Real V(unit="lit") "Volume of reactor";
Real Ca0(unit="mol/lit") "Initial concentration of A";
Real EA(unit="No units") "Fractional conversion";
Real[4] Fa01(unit="mol/sec") "Molar flow rate of acetone";
Real[4] k(unit="sec^-1") "Rate constant";
Real K(unit="sec^-1") "Average rate constant";
Real Rate(unit="mol/sec.lit") "Rate ";
equation
EA=(N0-N)/N;
for i in 1:4 loop
  Fa01[i]=(Fa0[i]/MW)/3600;
end for;
V=((2*asin(1.0))/4*D^(2)*L)/1000;
Ca0=pA0/(R*T);
for i in 1:4 loop
  k[i]=(Fa01[i]/(Ca0*V))*(2*(log(1/(1-XA[i])))-XA[i]);
end for;
K=sum(k)/4;
Rate=K;
//Rate=K*Ca//
end Ex3_33;
