model Ex3_41
parameter Real XA(unit="No units")=0.95 "Conversion";
parameter Real Ca0(unit="mol/lit")=2 "Initial concentration of A";
parameter Real v0(unit="lit/min")=25 "Volumetric flow rate";
Real Caf(unit="mol/lit") "Final concentration of A";
Real V(unit="lit") "Volume of reactor";
equation
//From derivations//
Caf=Ca0*(1-XA);
//By substituting the limits//
V=(-10*(log(Caf)-log(Ca0))-(5*(Caf-Ca0)))*v0;
end Ex3_41;
