model Ex3_45
parameter Real b(unit="mol")=1 "Moles of product";
parameter Real a(unit="mol")=2 "Moles of Reactant";
parameter Real Ca0(unit="mol/lit")=1 "Initial concentration of A";
parameter Real Ca(unit="mol/lit")=0.5 "Concentration of A";
parameter Real V(unit="lit")=2 "Volume";
parameter Real k(unit="lit/(mol.min")=0.05 "Rate constant";
Real EA(unit="No units") "Fractional Conversion";
Real XA(unit="No units") "Conversion";
Real v0(unit="lit/sec") "Volumetric flow rate";
equation
EA=(b-a)/a;
XA=(1-(Ca/Ca0))/(1+(EA*(Ca/Ca0)));
v0=(V*k*(Ca)^(2))/(Ca0*XA);
end Ex3_45;
