model Ex3_47
parameter Real Ca0(unit="mmol/lit")=660 "Initial concentration of A";
parameter Real b(unit="mol")=1 "Moles of product";
parameter Real a(unit="mol")=3 "Moles of Reactant";
parameter Real Ca(unit="mmol/lit")=330 "Final concentration of A";
parameter Real Fa0(unit="mmol/min")=540 "Molar flow rate";
parameter Real k(unit="min^(-1)")=54 "Rate cosntant";
Real EA(unit="No units") "Extent of the reaction";
Real XA(unit="No units") "Conversion";
Real V(unit="Lit") "Volume of reactor";
equation
EA=(b-a)/a;
XA=(1-(Ca/Ca0))/(1+(EA*(Ca/Ca0)));
V=(Fa0/(k*Ca0))*(-((1+EA)*log(1-XA))-(EA*XA));
end Ex3_47;
