model Ex3_9
parameter Real Ca0(unit="mol/lit")=0.01 "Initial concentration of A";
parameter Real Cb0(unit="mol/lit")=0.02 "Initial concentration of B";
parameter Real Cr0(unit="mol/lit")=0 "Initial concentration of B";
parameter Real V(unit="lit")=1 "Initial volume";
parameter Real v(unit="lit/min")=6 "Volumetric flow rate";
parameter Real Ca(unit="mol/lit")=0.0005 "Final concentration of A";
parameter Real Cr(unit="mol/lit")=0.001 "Concentration of R";
parameter Real va(unit="lit/min")=1 "Volumetric flow rate of A";
parameter Real vb(unit="lit/min")=3 "Volumetric flow rate of A";
Real v0(unit="lit/min") "Total Volumetric flow rate";
Real EAXA(unit="No units") "Fractional Conversion";
Real XA(unit="No units") "Conversion";
Real Ca01(unit="mol/lit") "Concentration of A entering the reactor";
Real Tow(unit="min") "Space time";
Real rateA(unit="mol/lit.min") "Rate of mixed flow reactor wrt A";
Real rateR(unit="mol/lit.min") "Rate of mixed flow reactor wrt R";
equation
//Mixed flow reactor performance equation//
v0=va+vb;
EAXA=(v/v0)-1;
//Concentration of A entering the reactor//
Ca01=Ca0*(va/v0);
//For changing density systems//
XA=1-((Ca*(1+EAXA))/Ca01);
Tow=V/v0;
rateA=(Ca01*XA)/Tow;
rateR=(Cr-Cr0)/Tow;
end Ex3_9;
