model Ex4_16 
parameter Real Ca0(unit="mol/lit")=0.020 "Initial concentration of A";
parameter Real Cr0(unit="mol/lit")=0.002 "Initial concentration of R";
parameter Real V1(unit="lit")=4 "Volume of CSTR";
parameter Real V2(unit="lit")=16 "Volume of plug flow reactor";
Real C0(unit="mol/lit") "Concentration of each stream entering the reactor";
Real C1(unit="mol/lit") "Concentration in the 1st reactor";
Real ktow(unit="No units") "Rate constant*Space time of CSTR";
Real ktowp(unit="No units") "Rate constant*Space time of plug flow reactor";
Real C2(unit="mol/lit") "Concentration at outlet";
Real X2(unit="No units")"Conversion at the end of PFR";
Real CR2(unit="mol/lit") "Concentration of R at the exit";
equation
C0=Ca0/2;
//If the volumetric flow rate of each stream is 1lit/min,then the volumetric flow rate of mixed stream is 2lit/min//
C1=C0-Cr0;
ktow=(C0-C1)/C1;
ktowp=(V2/V1)*ktow;
C2=C1/exp(ktowp);
X2=1-(C2/C0);
CR2=C0*X2;
end Ex4_16;
