model Ex4_19
parameter Real EA(unit="No units")=0 "Liquid phase";
parameter Real Ca0(unit="mol/lit")=1 "Initial concentration";
parameter Real XA(unit="No units")=0.96 "Conversion";
Real tow1(unit="sec") "Vm/v0";
Real XA1(unit="No units") "Conversion in PFR for first arrangment";
Real XA2(unit="No units") "Conversion from PFR followed by CSTR";
Real XA3(unit="No units") "Conversion in MFR for second arrangment";
Real XA4(unit="No units") "Conversion in MFR followed by PFR";
Real Percentage1(unit="Percent") "Percentage increase in conversion in first arrangment";
Real Percentage2(unit="Percent") "Percentage increase in conversion in second arrangment";
equation
//PFR followed by MFR//
tow1=10*(1/(1-XA)-1);
//Plug flow reactor conversion//
XA1=XA;
tow1=Ca0*(XA2-XA1)/(Ca0^(2)*(1-XA2)^(2));
Percentage1=((XA2-XA1)/XA1)*100;
//MFR followed by PFR//
tow1=Ca0*(XA3)/(Ca0^(2)*(1-XA3)^(2));
tow1/10=(1/(1-XA4)-(1/(1-XA3)));
Percentage2=((XA4-XA1)/XA1)*100;
end Ex4_19;
