model Ex5_5
parameter Real Ca0(unit="mol/m^3")=40 "Initial concentration";
parameter Real k1(unit="m^3/(mol.min)")=0.4 "Rate constant of 1st reaction";
parameter Real k2(unit="min^-1")=2 "Rate constant of 2nd reaction";
Real Ca(unit="mol/m^3") "Exit concentration of A";
Real Cr(unit="mol/m^3") "Maximum amount of R formed";
Real XA(unit="No units") "Conversion";
Real tow(unit="min") "Space time";
equation
5*Ca0-Ca^(2)-10*Ca=0;
Cr=(1/(1+(5/Ca)))*(Ca0-Ca);
XA=(Ca0-Ca)/Ca0;
//For mixed flow reactor//
tow=XA/((k1*Ca0*((1-XA)^(2)))+(k2*(1-XA)));
end Ex5_5;
