model Ex5_9
parameter Real Ca0(unit="mol/m^3")=40 "Initial concentration of A";
parameter Real k1(unit="m^3/(mol.min)")=0.4 "Rate constant of 1st reaction";
parameter Real k2(unit="min^-1")=2 "Rate constant of 2nd reaction";
parameter Real XA(unit="No units")=0.90 "Conversion";
parameter Real Cr0(unit="mol/m^3")=0 "Initial concentration of R";
parameter Real Cs0(unit="mol/m^3")=0 "Initial concentration of S";
Real tow(unit="min") "Space Time";
Real Ca(unit="mol/m^3") "Concentration of A at exit";
Real Cr(unit="mol/m^3") "Concentration of R at exit";
Real Cs(unit="mol/m^3") "Concentration of S at exit";
equation
tow=(Ca0*XA)/((k1*Ca0^(2)*(1-XA)^(2))+(k2*Ca0*(1-XA)));
Ca=Ca0*(1-XA);
Cr=Cr0+(k1*tow*Ca^(2));
Cs=Cs0+(k2*tow*Ca);
//Ca0=Ca+Cr+Cs//
end Ex5_9;
