model Ex6_10
parameter Real W(unit="g")=10.425 "Initial amount of phosphorous pentachloride";
parameter Real MW(unit="g/gmol")=208.5 "Molecular weight of phosphorous pentachloride";
parameter Real V(unit="Lit")=4 "Volume";
parameter Real P(unit="atm")=1 "Pressure";
parameter Real T(unit="K")=540 "Temperature";
parameter Real R(unit="lit.atm/mol.K")=0.08206 "Gas constant";
parameter Real R1(unit="cal/mol.K")=1.987 "Gas constant";
parameter Real cl2(unit="No units")=1 "Stiochiometric coefficient";
parameter Real Pcl3(unit="No units")=1 "Stiochiometric coefficient";
parameter Real Pcl5(unit="No units")=1 "Stiochiometric coefficient";
Real Moles(unit="Moles") "Moles of phosporous pentachloride";
Real X(unit="moles") "Moles of Pcl3 and cl2 formed";
Real Totalmoles(unit="Moles") "Total number of moles";
Real ypcl5(unit=" No units") "Mole fraction of Pcl5";
Real ypcl3(unit="No units")"Mole fraction of Pcl3";
Real ycl2(unit="No units")"Mole fraction of cl2";
Real Kp(unit="atm") " Equilibrium Pressure";
Real kc(unit="mol/lit") " Equlibrium Concentration";
Real delN(unit="Number") "Stiochiometric coefficient";
Real delG(unit="cal/mol") "Gibbs free energy";
equation
Moles=W/MW;
//According to ideal gas law//
Totalmoles=(P*V)/(R*T);
X=Totalmoles-Moles;
ypcl5=(Moles-X)/(Totalmoles);
ypcl3=X/Totalmoles;
ycl2=X/Totalmoles;
delN=(Pcl3+cl2)-Pcl5;
Kp=((ycl2)*(ypcl3)/(ypcl5))*P^(delN);
kc=Kp/((R*T)^(delN));
delG=-(R1*T*log(Kp));
//The answers given in the book are wrong//
end Ex6_10;
