model Ex10_2
//Parameter Section 
parameter Real D(unit = "m") = 0.1524 "Outside diameter of the pipe";
parameter Real Ts(unit = "C") = 37.77 "Outer Surface temperature of the horizontal pipe";
parameter Real To(unit = "C") = 26.6 "Temperature of the surrounding air";
parameter Real mu(unit = "N.s/m^2") = 0.019*10^(-3) "Viscosity of the air at film temperature";
parameter Real rho(unit = "kg/m^3") = 1.156 "Density of the air at film temperature";
parameter Real Cp(unit = "J/kg.K") = 3.196*10^3 "Specific heat of the air at film temperature";
parameter Real K(unit = "W/m.K") = 0.0833 "Thermal conductivity of the air at film temperature";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";
//==============================================================================================
//Variable Section
Real Tf(unit = "C") "Film Temperature";
Real beta(unit = "K^(-1)") "Coefficient of thermal expansion";
Real delT(unit = "K") "Temperature driving force";
Real Gr(unit = "nil") "Grashof number";
Real Pr(unit = "nil") "Prandtl number";
Real GrPr(unit = "nil") "Product of Prandtl number and Grashof number";
Real Nu(unit = "nil") "Nusselt number";
Real h(unit = "W/m^2.K") "Heat transfer coefficient";
Real Q_per_L(unit = "W/m") "Rate of heat loss by free convection per unit length";
//==============================================================================================
//Equation Section
equation 
Tf = (Ts+To)/2;
beta = 1/(Tf+273);
delT = Ts-To;
Gr = (D^3*rho^2*g*delT*beta)/(mu^2);
Pr = (Cp*mu)/K;
GrPr = Gr*Pr;
Nu = 0.158*((GrPr)^(1/4));
h = (Nu*K)/D;
Q_per_L = h*3.14*D*delT;
end Ex10_2;
//The answer may slightly vary due to rounding off values
