model Ex11_2
//Parameter Section
parameter Real Tb1(unit = "C") = 21.1 "Initial Temperature of the air";
parameter Real Tb2(unit = "C") = 110 "Final Temperature of the air";
parameter Real T0(unit = "C") = 121.1 "Inside Wall Temperature";
parameter Real mub(unit = "N.s/m^2") = 2*10^(-5) "Viscosity at Tb";
parameter Real mu0(unit = "N.s/m^2") = 2.2*10^(-5) "Viscosity at wall temperature";
parameter Real Cp(unit = "J/kg.K") = 1000 "Specific heat capacity at Tb";
parameter Real K(unit = "W/m.K") = 0.0292 "Thermal conductivity at Tb";
parameter Real w(unit = "kg/s") = 8.8*10^(-3) "Mass flow rate of the air";
parameter Real D(unit = "m") = 5.08*10^(-2) "Inside diameter of the pipe";
//======================================================================================
//Variable Section
Real Tb(unit = "C") "Bulk Temperature of the fluid";
Real Re(unit = "nil") "Reynolds number";
Real Pr(unit = "nil") "Prandtl number";
Real L(unit = "m") "Length of the pipe";
//======================================================================================
//Equation Section
equation 
Tb = (Tb1+Tb2)/2;
Re = (4*w)/(3.14*D*mub);
Pr = (Cp*mub)/K;
L = (D/(4*0.0039))*(Pr)^(2/3)*log((T0-Tb1)/(T0-Tb2))*(mub/mu0)^(-0.14);
// Given that (D/(4*L))*(Pr)^(2/3)*log((T0-Tb1)/(T0-Tb2))*(mub/mu0)^(-0.14) = 0.0039
end Ex11_2;
