model Ex12_1
//Parameter Section
parameter Real lambda_max(unit = "microns") = 0.5 "Maximum monochromatic emissive power";
parameter Real sigma(unit = "Btu/hr.ft^2.degF^4") = 0.1712*10^(-8) "Steafan-Boltzmann constant";
//===================================================================================
//Variable Section
Real T_K(unit = "K") "Surface temperature of the sun in K";
Real T_R(unit = "R") "Surface temperature of the sun in R";
Real q (unit = "Btu/hr.ft^2") "Emitted heat flux at the surface of the sun";
//===================================================================================
//Equation Section
equation 
T_K = 0.2884/(lambda_max*10^(-4)); // 1 micron = 10^(-4) cm // Wien's Displacement law
T_R = (((T_K-273.15)*1.8)+32)+459.67; // Conversion factor C = K-273; F = 32+1.8C; R = F+459.67
q = sigma*T_R^4;//Stefan - Boltzmann law
end Ex12_1;
// The answer may slightly vary due to rounding off values
