model Ex12_7
//Parameter Section
parameter Real D(unit = "ft") = 2 "Diameter of the black disc";
parameter Real F12(unit = "nil") = 0.06 "Shape factor";
parameter Real T1(unit = "C") = 837.96 "Temperature of the disc 1";
parameter Real T2(unit = "C") = 282.4 "Temperature of the disc 2";
parameter Real sigma(unit = "W/m^2.R^4") = 5.67*10^(-8) "Stefan-Boltzmann constant";
//====================================================================================== 
//Variable Section
Real A1(unit = "m^2") "Area of the black disc";
Real Q12(unit = "W") "Heat flow between the two discs";
//======================================================================================
//Equation Section
equation 
A1 = (3.14*(D*0.3048)^2)/4; //1 ft = 0.3048 m
Q12 = A1*F12*sigma*((T1+273)^4-(T2+273)^4);
end Ex12_7;
//The answer provided in the textbook is wrong
//The value of area has been substituted wrongly in the textbook
