model Ex13_10
//Parameter Section
parameter Real mu(unit = "cP") = 0.705 "Viscosity of the pure benzene";
parameter Real V_A(unit = "cm^3/gmole") = 140 "Molar volume of the TNT";
parameter Real psi_B(unit = "nil") = 1 "Association parameter for Benzene";
parameter Real M_B(unit = "g/gmole") = 78.11 "Molecular weight of benzene";
parameter Real T(unit = "K") = 288 "Absolute Temperature";
//==========================================================================
//Variable section
Real D_AB(unit = "cm^2/s") "Diffusivity of TNT in benzene";
//==========================================================================
//Equation section
equation
D_AB = (7.4*10^(-8)*(psi_B*M_B)^(1/2)*T)/(mu*V_A^0.6);//Wilke-Chang Correlation
end Ex13_10;
