model Ex13_6
//Parameter Section 
parameter Real D_AB1(unit = "cm^2/s") = 1.28*10^(-5) "Diffusivity of the dilute solution of methanol in water at 15 deg C";
parameter Real T_1(unit = "C") = 15 "Temperature of the solution";
parameter Real mu_1(unit = "cP") = 1.14 "Viscosity at 15 C";
parameter Real T_2(unit = "C") = 100 "Temperature of the same solution for different diffusivity";
parameter Real mu_2(unit = "cP") = 0.284 "Viscosity at 100 C";
//=========================================================================================================
//Variable Section
Real D_AB2(unit = "cm^2/s") "Diffusivity of the same solution at 100 C";
//=========================================================================================================
//Equation Section
equation 
D_AB2 = (D_AB1*mu_1*(T_2+273))/(mu_2*(T_1+273)); // D_AB is inversely proportional to viscosity and directly proportional to temperature (From Wilke-Chang equation) 
end Ex13_6;
