model Ex13_9
//Parameter Section
parameter Real psi_B(unit = "nil") = 2.6 "Association parameter for water";
parameter Real MW_B(unit = "g/gmole") = 18 "Molecular weight of the solvent i.e. water";
parameter Real mu(unit = "cP") = 0.8937 "Viscosity of the water";
parameter Real T(unit = "deg C") = 25 "Temperature of the solution";
parameter Real C(unit = "cm^3/gmole") = 14.8 "Atomic volume of carbon";
parameter Real H(unit = "cm^3/gmole") = 3.7 "Atomic volume of hydrogen";
parameter Real O(unit = "cm^3/gmole") = 7.4 "Atomic volume of oxygen";
//============================================================================================
//Variable Section
Real V_A(unit = "cm^3/gmole") "Molar Volume of the solute";
Real D_AB(unit = "cm^2/s") "Diffusivity for acetone in water";
//============================================================================================
//Equation Section
equation
V_A = (3*C)+(6*H)+(1*O); // There are 3 carbon atoms, 6 hydrogen atoms and one oxygen atom present in the acetone
D_AB = (7.4*10^(-8)*sqrt(psi_B*MW_B)*(T+273))/(mu*V_A^0.6); //Wilke Chang correlation
end Ex13_9;
