model Ex14_1
//Parameter Section
parameter Real D_AB(unit = "m^2/s") = 1.26*10^(-9) "Diffusivity of chlorine-water system";
parameter Real V_avg(unit = "m/s") = 17.7*10^(-2) "Average velocity of the absorbing fluid i.e. water";
parameter Real rho_w(unit = "g/cm^3") = 1 "Density of water"; 
parameter Real MW_Cl(unit = "kg/kmole") = 71 "Molecular weight of Chlorine";
parameter Real Sol(unit = "gm Cl2/gm H2O") = 0.823/100 "Solubility of Chlorine in water";
parameter Real L(unit = "m") = 13*10^(-2) "Length of the column";
parameter Real R(unit = "m") = 1.4*10^(-2) "Radius of the column";
//=====================================================================================================
//Variable Section
Real CA0(unit = "kmole/m^3") "Concentration of Chlorine in water";
Real V_max(unit = "m/s") "Maximum Velocity";
Real W(unit = "m") "Perimeter of the tube"; 
Real WA(unit = "kmole/s") "Absorption rate in kmole/s";
Real W_A(unit = "gmole/hr") "Absorption rate in gmole/hr";
//=====================================================================================================
//Equation Section
equation 
CA0 = (Sol*rho_w*1000)/(MW_Cl); //Saturation concentration of Cl2 in water is 0.823 g of Cl2 per 100 g of water
V_max = (3*V_avg)/2;
W = 2*3.14*R;
WA = W*L*CA0*sqrt((4*D_AB*V_max)/(3.14*L));
W_A = WA*3600*1000;
end Ex14_1;
