model Ex14_14
//Parameter Section
parameter Real PT(unit = "kN/m^2") = 100.63 "Total pressure of the system";
parameter Real p_A1(unit = "kN/m^2") = 4.39 "Vapor pressure of CCl4 at 0 C";
parameter Real p_A2(unit = "kN/m^2") = 0 "Vapour pressure of CCl4 at point 2";
parameter Real T(unit = "K") = 273 "Temperature of the system";
parameter Real R(unit = "J/kmole.K") = 8314 "Universal gas constant";
parameter Real delz(unit = "m") = 0.171 "Distance between two points";
parameter Real rho(unit = "kg/m^3") = 1590 "Density of the CCl4";
parameter Real MW(unit = "kg/kmole") = 154 "Molecular weight of CCl4";
parameter Real t(unit = "hr") = 10 "Time for evaporation";
parameter Real A(unit = "m^2") = 0.82*10^(-4) "Cross sectional area of the diffusion tube";
parameter Real m(unit = "m^3") = 0.0208*10^(-6) "Amount of CCl4 evaporated in 10 hours";
//===============================================================================================
//Variable Section
Real p_B1(unit = "kN/m^2") "Vapour pressure of oxygen at point 1";
Real p_B2(unit = "kN/m^2") "Vapour pressure of oxygen at point 2";
Real p_B_lm(unit = "KN/m^2") "Logarithmic mean partial pressure";
Real N_AB(unit = "kmole/m^2.s") "Flux";
Real D_AB(unit = "m^2/s") "Diffusivity of the gas pair CCl4-O2";
//===============================================================================================
//Equation Section
equation
p_B1 = 101.3-p_A1; //1 atm = 101.3 kN/m^2
p_B2 = 101.3-p_A2;
p_B_lm = (p_B2-p_B1)/log(p_B2/p_B1);
N_AB = (m*rho)/(MW*A*t*3600);
//0.0208 cm^3 of CCl4 evaporate in 10 hours period after steady state has been attained
N_AB = (D_AB*PT*10^3*(p_A1-p_A2)*10^3)/(R*T*delz*p_B_lm*10^3);
end Ex14_14;
