model Ex14_2
//Parameter Section
//A-Oxygen B-Nitrogen
parameter Real D_AB_0_degC(unit = "m^2/s") = 1.81*10^(-5) "Diffusivity of O2-N2 at 0 deg C";
parameter Real p_A1(unit = "N/m^") = 0.1*10^5 "Partial pressure of Oxygen at plane 1";
parameter Real p_A2(unit = "N/m^2") = 0.2*10^5 "Partial pressure of Oxygen at plane 2";
parameter Real P_T(unit = "N/m^2") = 1*10^5 "Total Pressure of the system";
parameter Real delz(unit = "m") = 2*10^(-3) "Distance between two planes";
parameter Real T(unit = "K") = 298 "Temperature of the system";
parameter Real R(unit = "J/Kmol.K") = 8314 "Universal gas constant";
//=========================================================================================================
//Variable Section
Real p_B1(unit = "N/m^2") "Partial pressure of nitrogen at plane 1";
Real p_B2(unit = "N/m^2") "Partial pressure of nitrogen at plane 2";
Real D_AB(unit = "m^2/s") "Diffusivity of O2-N2 at 25 deg C";
Real P_B_lm(unit = "N/m^2") "Logarithmic mean partial pressure";
Real NA(unit = "Kmole/m^2.s") "Flux of diffusion of O2 through non-diffusing N2 gas";
Real Na(unit = "Kmole/m^2.s") "Equimolar counter diffusion";
//=========================================================================================================
//Equation Section
equation
p_B1 = P_T - p_A1;
p_B2 = P_T - p_A2;
P_B_lm = (p_B1-p_B2)/log(p_B1/p_B2);
D_AB = D_AB_0_degC*(298/273)^1.5;
NA = (D_AB*P_T*(p_A1-p_A2))/(R*T*delz*P_B_lm);
Na = (D_AB*(p_A1-p_A2))/(R*T*delz);
//-ve sign shows that diffusion happens in opposite direction 
end Ex14_2;
//The answer provided in the book for sub-division 1 is wrong as the formula followed in the textbook is wrong. The answer should be of negative value

