model Ex14_8
//Parameter Section
//A = Water B = Air
parameter Real D_AB(unit = "m^2/s") = 2.6*10^(-5) "Diffusivity of water vapour in air";
parameter Real p_A1(unit = "N/m^2") = 4.112*10^3 "Partial pressure of water vapour at point 1";
parameter Real p_A2(unit = "N/m^2") = 0 "Partial pressure of water vapour at point 2"; //Since pure air
parameter Real P_T(unit = "N/m^2") = 1.013*10^5 "Total Pressure of the system";
parameter Real delz(unit = "m") = 10 "Distance between two points";
parameter Real T(unit = "K") = 303 "Temperature of the system";
parameter Real R(unit = "J/Kmol.K") = 8314 "Universal gas constant";
parameter Real MW(unit = "kg/kmole") = 18 "Molecular weight of water";
parameter Real D(unit = "m") = 1 "Diameter of the well";
//==========================================================================================================
//Variable Section
Real p_B1(unit = "N/m^2") "Partial pressure of air at point 1";
Real p_B2(unit = "N/m^2") "Partial pressure of air at point 2";
Real P_B_lm(unit = "N/m^2") "Logarithmic mean partial pressure";
Real NA(unit = "Kmole/m^2.s") "Flux of diffusion of water vapour through non-diffusing air in kmole/m^2.s";
Real N_A(unit = "Kg/m^2.s") "Flux of diffusion of water vapour through non-diffusing air in kg/m^2.s";
Real N_A_SS(unit = "Kg/s") "Steady state diffusion of water in kg/s";
//===========================================================================================
//Equation Section
equation
p_B1 = P_T - p_A1;
p_B2 = P_T - p_A2;
P_B_lm = (p_B2-p_B1)/log(p_B2/p_B1);
NA = (D_AB*P_T*(p_A1-p_A2))/(R*T*delz*P_B_lm);
N_A = NA*MW;
N_A_SS = (N_A*3.14*D^2)/4;
end Ex14_8;
//The answer may vary due to rounding off values

