model Ex2_2
//Parameter Section
parameter Real tau(unit = "N/m^2") = 0.3 "Shear stress";
parameter Real mu(unit = "N.s/m^2") = 0.4*10^(-2) "Viscosity of the fluid";
parameter Real V1(unit = "m/s") = 0.4 "Velocity of lower plate";
parameter Real V2(unit = "m/s") = 0 "Velocity of top plate";
parameter Real y1(unit = "m") = 0 "Distance of the lower plate from the reference";
parameter Real mu_new(unit = "N.s/m^2") = 2*10^(-2) "Viscosity of the fluid";
//====================================================================================
//Variable Section
Real y2(unit = "m") "Distance of the top plate from the reference";
Real tau_new(unit = "N/m^2") "Shear stress for the new viscosity";
Real Rate(unit = "s^(-1)") "Shear rate";
//====================================================================================
//Equation Section
equation 
y2 = (((-mu)*(V2-V1))/tau)+y1;
tau_new = ((-mu_new)*(V2-V1))/(y2-y1);
Rate = (V1-V2)/(y2-y1);
end Ex2_2;
