model Ex2_4
//Parameter SEction
parameter Real K(unit = "erg/mol.K") = 1.38*10^(-16) "Boltzmann constant";
parameter Real T(unit = "K") = 273.2 "Temperature of the system";
parameter Real MW(unit = "g/gmole") = 32 "Molecular weight of oxygen";
parameter Real N(unit = "gmole^(-1)") = 6.023*10^23 "Avagadro number";
parameter Real n(unit = "nil") = 2.68*10^15 "Flow behaviour index";
parameter Real d(unit = "cm") = 3*10^(-8) "Molecular diameter";
//=============================================================================
//Variable Section 
Real m(unit = "gm") "Mass";
Real u(unit = "cm/s") "Mean molecular velocity";
Real lambda(unit = "cm") "Mean free path";
Real Ratio(unit = "nil") "Ratio of the mean free path to molecular diameter";
//=============================================================================
//Equation Section
equation 
m = MW/N;
u = sqrt((8*K*T)/(3.14*m));
lambda = 1/((sqrt(2))*n*d^2*3.14);
Ratio = lambda/d;
end Ex2_4;
