model Ex3_5
//Parameter Section
parameter Real delP(unit = "N/m^2") = 275.79*10^3 "Pressure drop";
parameter Real D(unit = "m") = 2.54*10^(-3) "Diameter of the horizontal tube";
parameter Real Q(unit = "m^3/s") = 1.878*10^(-6) "Volumetric flow rate of Glycerine";
parameter Real L(unit = "m") = 0.3048 "Length of the horizontal tube";
parameter Real rho(unit = "kg/m^3") =1261 "Density of Glycerine";
//===================================================================================
//Variable Section
Real R(unit = "m") "Radius of the horizontal tube";
Real mu(unit = "N.s/m^2") "Viscosity of Glycerine";
Real mu_cP(unit = "cP") "Viscosity of Glycerine in cP";
Real A(unit = "m^2") "Area of the tube";
Real V_z(unit = "m/s") "Velocity of Glycerine";
Real Re(unit = "nil") "Reynolds number";
//===================================================================================
//Equation Section
equation
R = D/2;
mu = (3.14*delP*R^4)/(8*Q*L); //Hagen-Poiseuille equation //Laminar flow is assumed
mu_cP = mu*10^3;
A = (3.14*D^2)/4;
V_z = Q/A;
Re = (D*V_z*rho)/mu; // If Re < 1000 to 2000, assumed laminar flow is correct
end Ex3_5;
