model Ex5_1
//Parameter Section
parameter Real K(unit = "N.s^n/m^2") = 15.23 "Rheological or flow property of the fluid";
parameter Real n(unit = "nil") = 0.4 "Rheological or flow property of the fluid";
parameter Real D(unit = "m") = 0.0524 "Inside diameter of the tubing";
parameter Real L(unit = "m") = 14.9 "Length of the tubing";
parameter Real V(unit = "m/s") = 0.0728 "Average velocity of the power-law fluid";
parameter Real rho(unit = "kg/m^3") = 1041 "Density of the fluid";
//========================================================================================
//Variable Section
Real delP(unit = "N/m^2") "Pressure drop";
Real Ff(unit = "J/kg") "Friction loss";
Real Re_gen(unit = "nil") "Generalized Reynolds number";
Real f(unit = "nil") "Friction factor";
Real delp(unit = "N/m^2") "Pressure drop calculated using friction factor method";
//========================================================================================
//Equation Section
equation 
delP = ((K*4*L)/D)*((8*V)/D)^n;
Ff = delP/rho;
Re_gen = (D^n*V^(2-n)*rho)/(K*8^(n-1)); //If Re,gen < 2000, the flow is laminar. Here the flow is laminar
f = 16/Re_gen;
delp = (4*f*rho*L*V^2)/(2*D);
end Ex5_1;
//The answer may slightly vary due to rounding off values
