model Ex5_2
//Parameter Section
parameter Real K(unit = "N.s^n/m^2") = 2.744 "Flow property of the fluid";
parameter Real n(unit = "nil") = 0.3 "Flow property of the fluid";
parameter Real D(unit = "m") = 0.0508 "Inside diameter of the tubing";
parameter Real L(unit = "m") = 30.5 "Length of the tubing";
parameter Real V(unit = "m/s") = 6.10 "Average velocity of the pseudoplastic fluid";
parameter Real rho(unit = "kg/m^3") = 961 "Density of the fluid";
parameter Real f(unit = "nil") = 0.0032 "Friction factor from the graph for the calculated Reynolds number"; //Pg.no 5.2; fig 5.2 NRe,gen for time independent fluids flowing in a tube
//=================================================================================
//Variable Section
Real Re_gen(unit = "nil") "Generalized Reynolds number";
Real delP(unit = "N/m^2") "Pressure drop calculated using friction factor method";
//=================================================================================
//Equation Section
equation 
Re_gen = (D^n*V^(2-n)*rho)/(K*8^(n-1));
delP = (4*f*rho*L*V^2)/(2*D);
end Ex5_2;
