model Ex5_3
//Parameter Section
parameter Real tau0(unit = "N/m^2") = 0.4 "Yield stress";
parameter Real mu(unit = "Pa.s") = 0.25 "Viscosity of the printing pigment solution";
parameter Real delP(unit = "N/m^2") = 4350 "Pressure driving force";
parameter Real L(unit = "m") = 10.2 "Length of the pipe";
parameter Real D(unit = "m") = 0.01 "Diameter of the pipe";
//=====================================================================================
//Variable Section 
Real R(unit = "m") "Radius of the pipe";
Real r0(unit = "m") "Radius at which yield stress occurs";
Real tauR(unit = "N/m^2") "Stress";
Real Q(unit = "m^3/s") "Flow rate";
Real Vx_avg(unit = "m/s") "Average velocity";
//=====================================================================================
//Equation Section
equation
R = D/2;
tau0 = (delP*r0)/(2*L);
tauR = (delP*R)/(2*L);
Q = (3.14*delP*R^4*(1-((4*tau0)/(3*tauR))+((1/3)*(tau0/tauR)^4)))/(8*mu*L);
Vx_avg = Q/(3.14*R^2);
end Ex5_3;
