model Ex6_12
//Parameter Section
parameter Real A(unit = "m^2") = 9.41*10^(-2) "Cross sectional area of the column";
parameter Real L(unit = "m") = 1.85 "Height of the column";
parameter Real Dp(unit = "m") = 2*10^(-3) "Diameter of the particle";
parameter Real delP(unit = "N/m^2") = 1.089*10^6 "Pressure difference across the bed";
parameter Real mu(unit = "kg/m.s") = 56.5*10^(-3) "Viscosity of the sucrose solution";
parameter Real rho(unit = "kg/m^3") = 1286 "Density of the solution";
parameter Real m(unit = "kg/s") = 1.844 "Mass flow rate of the solution";
//=======================================================================================================
//Variable Section
Real V(unit = "m/s") "Velocity";
Real Re_p(unit = "nil") "Particle Reynolds number";
Real epsilon(unit = "nil") "Void fraction";
//=======================================================================================================
//Equation Section
equation 
V = m/(A*rho);
Re_p = (Dp*V*rho)/mu;
(delP/L) = ((150*mu*V*(1-epsilon)^2)/(Dp^2*epsilon^3))+((1.75*rho*V^2*(1-epsilon))/(Dp*epsilon^3));
//Kozney-Karman's equation
end Ex6_12;
