model Ex6_5
//Parameter Section
parameter Real Q(unit = "lit/hr") = 75 "Volumetric flow rate of benzene";
parameter Real D(unit = "m") = 2.35*10^(-2) "Diameter of the pipe";
parameter Real L(unit = "m") = 30 "Length of the pipe";
parameter Real mu(unit = "N.s/m^2") = 0.65*10^(-3) "Viscosity of benzene"; 
parameter Real rho(unit = "kg/m^3") = 880 "Density of the benzene";
//============================================================================
//Variable Section
Real Q_m3_per_s(unit = "m^3/s") "Volumetric flow rate in m^3/s";
Real A(unit = "m^2") "Area of the pipe";
Real Vavg(unit = "m/s") "Average Velocity of the fluid";
Real Re(unit = "nil") "Reynolds number";
Real f(unit = "nil") "Friction factor";
Real delP(unit = "N/m^2") "Pressure drop";
Real Vmax(unit = "m/s") "Maximum Velocity at the centre of the pipe";
//============================================================================
//Equation Section
equation 
Q_m3_per_s = Q/(1000*3600); //1 m^3 = 1000 L //1 hr = 3600 s
A = (3.14*D^2)/4;
Vavg = Q_m3_per_s/A;
Re = (D*Vavg*rho)/mu; //If Re<2100, the flow is laminar
f = 16/Re; //Here laminar flow prevails
delP = (2*L*f*rho*Vavg^2)/D;
Vmax = 2*Vavg;
end Ex6_5;
//The answer may slightly vary due to rounding off values
