model Ex6_8
//Parameter Section
parameter Real D(unit = "m") = 0.05 "Diameter of the pipe";
parameter Real Re(unit = "nil") = 10^4 "Length of the pipe";
parameter Real mu(unit = "N.s/m^2") = 9*10^(-4) "Viscosity of water"; 
parameter Real rho(unit = "kg/m^3") = 1000 "Density of the water";
//============================================================================
//Variable Section
Real Vavg(unit = "m/s") "Average Velocity of the fluid";
Real f(unit = "nil") "Friction factor";
Real delP_per_L(unit = "kg/m^2.sec^2") "Pressure drop per unit length";
Real tau0(unit = "kg/m.s^2") "Yield stress";
Real V_s(unit = "m/s") "Velocity at viscous sublayer";
Real delta(unit = "m") "Thickness of the viscous sublayer";
//============================================================================
//Equation Section
equation 
Vavg = (Re*mu)/(D*rho);
f = 0.079/Re^0.25; //For turbulent flow
delP_per_L = (2*f*rho*Vavg^2)/D;
tau0 = (delP_per_L*D)/4;
V_s = sqrt(tau0/rho);
delta = (5*mu)/(V_s*rho);//The value of distance(dimensionless) is taken as 5
end Ex6_8;
