model Ex7_1
//Parameter Section
parameter Real mu(unit = "N.s/m^2") = 1.77*10^(-5) "Viscosity of the nitrogen gas";
parameter Real T(unit = "K") = 298.15 "Temperature of the system";
parameter Real P1(unit = "N/m^2") = 2.0265*10^(5) "Pressure at the entrance to the tube";
parameter Real G(unit = "kg/s.m^2") = 9 "Mass velocity of nitrogen gas";
parameter Real D(unit = "m") = 0.01 "Diameter of the tube";
parameter Real L(unit = "m") = 200 "Length of the tube";
parameter Real R(unit = "J/kmol.K") = 8314 "Universal gas constant";
parameter Real M(unit = "kg/kmole") = 28.05 "Molecular weight of nitrogen"; 
//===========================================================================================
//Variable Section
Real Re(unit = "nil") "Reynolds number";
Real f(unit = "nil") "Friction factor";
Real P2(unit = "N/m^2") "Pressure at the exit of the tube";
//===========================================================================================
//Equation Section
equation 
Re = (D*G)/mu; // If Re>2100, the flow is turbulent
f = 0.079/Re^0.25; //Here, the flow is turbulent
(P1-P2) = (2*f)*(L/D)*((G^2*R*T)/(((P1+P2)/2)*M));
end Ex7_1;
