model Ex7_10
//Parameter Section
parameter Real Q(unit = "m^3/s") = 0.0315 "Volumetric flowrate of water";
parameter Real D1(unit = "m") = 0.0635 "Inside diameter of the upstream";
parameter Real D2(unit = "m") = 0.0286 "Inside diameter of the downstream";
parameter Real rho(unit = "kg/m^3") = 1000 "Density of water";
parameter Real P2(unit = "N/m^2") = 1*10^5 "Exit pressure";
//===============================================================================================
//Variable Section
Real A1(unit = "m^2") "Area of the upstream";
Real A2(unit = "m^2") "Area of the downstream";
Real P1(unit = "N/m^2") "Entrance pressure";
Real V1(unit = "m/s") "Velocity of the upstream";
Real V2(unit = "m/s") "Velocity of the downstream";
Real m(unit = "kg/s") "Mass flow rate";
Real Rm(unit = "N") "Resultant force on the nozzle";
//===============================================================================================
//Equation Section
equation 
//Bernoulli's equation is
//(delP/rho)+(delz*g)+((V2^2-V1^2)/(2*alpha))+(eta*Wp)+Ev+F+W = 0
//Ev = 0; F = 0; W = 0
A1 = (3.14*D1^2)/4;
A2 = (3.14*D2^2)/4;
V1 = Q/A1;
V2 = Q/A2;
((V2^2-V1^2)/2)+((P2-P1)/rho) = 0;
m = Q*rho;
//Since the nozzle is horizontal, the resultant force acting on the nozzle is given by,
// Rm = m2V2-m1V1+P1A1-P2A2
Rm = m*(V2-V1)+(P1*A1)-(P2*A2);
end Ex7_10;
//The answer may vary due to rounding off values
