model Ex7_6
//Parameter Section
parameter Real Q(unit = "m^3/s") = 15.12*10^(-3) "Volumetric flow rate of the water";
parameter Real R1(unit = "m") = 0.0762 "Inner radius of the conduit";
parameter Real R2(unit = "m") = 0.1778 "Outer radius of the conduit";
parameter Real rho(unit = "kg/m^3") = 1000 "Density of water";
parameter Real mu(unit = "kg/m.s") = 0.001 "Viscosity of water";
parameter Real L(unit = "m") = 6.18 "Length of the conduit";
parameter Real delz(unit = "m") = 1.524 "Distance between the inlet and the outlet";
parameter Real g(unit = "m/s^2") = 9.8 "Acceleration due to gravity";
parameter Real eta(unit = "nil") = 1 "Efficiency of the pump"; //100% efficiency is assumed
//==========================================================================================================
//Variable Section
Real Rh(unit = "m") "Hydraulic radius";
Real De(unit = "m") "Equivalent diameter";
Real A(unit = "m^2") "Cross sectional area";
Real Vavg(unit = "m/s") "Average velocity";
Real Re(unit = "nil") "Reynolds number";
Real f(unit = "nil") "Friction factor for turbulent flow";
Real hf(unit = "J/kg") "Mechanical energy friction loss";
Real wp(unit = "J/kg") "Power required";
Real Wp(unit = "hp") "Power required";
//==========================================================================================================
//Equation Section
equation 
Rh = (R2-R1)/2;
De = 4*Rh;
A = (3.14*(R2^2-R1^2)*4)/4;
Vavg = Q/A;
Re = (De*Vavg*rho)/mu;
f = 0.079/Re^0.25; //For turbulent flow
hf = (4*f*L*Vavg^2)/(De*2);
//Bernoulli's equation is
//(delP/rho)+(delz*g)+((V2^2-V1^2)/(2*alpha))-(eta*Wp) = hf
//P1 = P2 (Given in the question)
//V1 = V2 since A1 = A2
(delz*g)-(eta*wp) = hf;
Wp = (wp*Q*rho)/746; //1 hp = 746 W 
end Ex7_6;
//The data given in the question is for diameter. But the solution is proceeded by taking the diameter as radius
//The above problem has been coded by following the solution
