model Ex7_9
//Parameter Section
parameter Real Q(unit = "lit/min") = 1701 "Volumetric flowrate of aqueous salt solution";
parameter Real D1(unit = "m") = 12.7*10^(-2) "Diameter of the smaller pipe";
parameter Real D2(unit = "m") = 22.86*10^(-2) "Diameter of the larger pipe";
parameter Real rho(unit = "kg/m^3") = 1008 "Density of the solution";
//==========================================================================================
//Variable Section
Real Vavg_1(unit = "m/s") "Average velocity 1";
Real Vavg_2(unit = "m/s") "Average velocity 2";
Real beta(unit = "nil") "Ratio of areas";
Real delP(unit = "N/m^2") "Pressure rise in N/m^2";
Real delP_psi(unit = "psi") "Pressure rise in psi";
//==========================================================================================
//Equation Section
equation 
Vavg_1 = (4*(Q*10^(-3))/60)/(3.14*D1^2); //1 m^3 = 1000 L; 1 min = 60 s
Vavg_2 = (D1^2/D2^2)*Vavg_1;
beta = D1^2/D2^2;
delP = rho*Vavg_2^2*((1/beta)-1); //Applying momentum balance
delP_psi = (delP/(1.01325*10^5))*14.69; //1 atm = 1.01325*10^5 N/m^2; 1 atm = 14.69 psi
end Ex7_9;
