model Ex9_12
parameter Real To(unit = "K") = 1100 "Temperature of the hot gas";
parameter Real Ta(unit = "K") = 300 "Temperature of the ambient air";
parameter Real ho(unit = "W/m^2.K") = 3000 "Heat transfer coefficient on the hot side";
parameter Real ha(unit = "W/m^2.K") = 22 "Heat transfer coefficient on the air side";
parameter Real k(unit = "W/m.k") = 0.138 "Thermal conducitivity of both fire brick and common brick";
parameter Real x1(unit = "m") = 0.12 "Thickness of fire brick layer";
parameter Real x2(unit = "m") = 0.25 "Thickness of common brick layer";
//==================================================================================
//Variable section
Real q(unit = "W/m^2") "Rate of heat transfer per unit area of wall";
Real T1(unit = "K") "Temperature at the interface of hot gases and fire brick";
Real T2(unit = "K") "Temperature at the interface of two bricks";
//==================================================================================
//Equation /section
equation
q = (To-Ta)/((1/ho)+(x1/k)+(x2/k)+(1/ha));
T1 = To-(q/ho);
T2 = T1-((q*x1)/k);
end Ex9_12;
