model Ex9_15
//Parameter Section
parameter Real D(unit = "m") = 0.31*10^(-2) "Diameter of the plastic insulation";
parameter Real d(unit = "m") = 0.001 "Diameter of the copper wire";
parameter Real L(unit = "m") = 1 "Length";
parameter Real h(unit = "W/m^2.K") = 8.52 "Heat transfer coefficient from the outer surface of the plastic to the surroundings";
parameter Real K(unit = "W/m.K") = 380.82 "Thermal conductivity of copper";
parameter Real Ke(unit = "ohm^(-1)cm^(-1)") = 5.1*10^5 "Elctrical conductivity of copper";
parameter Real T1(unit = "C") = 93.3 "Temperature of the copper wire";
parameter Real Tamb(unit = "C") = 37.8 "Ambient temperature";
//============================================================================================================
//Variable Section
Real r1(unit = "m") "Radius of the copper wire";
Real r2(unit = "m") "Radius of the plastic insulation";
Real T2(unit = "C") "Temperature of the plastic";
Real Q(unit = "W") "Rate of heat transfer";
Real Se(unit = "W/m^3") "Heat generated per unit volume";
Real I(unit = "amp/m^2") "Current";
Real current(unit = "amp") "Maximum steady current";  
//============================================================================================================
//Equation Section
equation
r1 = d/2;
r2 = D/2;
((K*(T1-T2))/log(r2/r1)) = h*(T2-Tamb);
Q = h*2*3.14*r2*L*(T2-Tamb);
Se = Q/(3.14*r1^2*L);
I^2 = Se*Ke*100;
current = I*3.14*r1^2;
end Ex9_15;
//The answer varies due to rounding off values
//The answer provided in the book for current is wrong
