model Ex9_20
//Parameter Section
parameter Real Awall(unit = "m^2") = 50*50*10^(-4) "Area of the vertical plane wall";
parameter Real d(unit = "m") = 0.01 "Diameter of each fin";
parameter Real L(unit = "m") = 0.1 "Length of the fin";
parameter Real h(unit = "W/m^2.K") = 15 "Surface heat transfer coefficient";
parameter Real K(unit = "W/m.K") = 300 "Thermal conductivity of the copper fin";
parameter Real Tw(unit = "C") = 200 "Temperature of the wall";
parameter Real Tinf(unit = "C") = 30 "Temperature of the surrounding";
//=====================================================================================
//Variable Section
Real A(unit = "m^2") "Cross sectional area of one fin";
Real P(unit = "m") "Perimeter of one fin";
Real NL(unit = "nil") "Dimensionless parameter";
Real phi(unit = "nil") "Fin effectiveness";
Real R_without_fins(unit = "K/W") "Thermal resistance without fin";
Real R_with_fins(unit = "K/W") "Thermal resistance with fin";
Real Af(unit = "m^2") "Surface area of 100 fins";
Real Abare(unit = "m^2") "Bare surface area of wall";
Real dec_R(unit = "K/W") "Decrease in thermal resistance";
Real Q_without_fins(unit = "W") "Heat transfer rate without fins";
Real Q_with_fins(unit = "W") "Heat transfer rate with fins";
Real inc_Rate(unit = "%") "Percentage increase in rate of heat transfer";
//=====================================================================================
//Equation Section
equation
A = (3.14*d^2)/4;
P = 3.14*d;
NL = sqrt((h*P)/(K*A))*L;
phi = tanh(NL)/NL;
R_without_fins = 1/(h*Awall);
Af = 100*P*L;
Abare = Awall-(100*A);
R_with_fins = 1/(h*((phi*Af)+Abare));
dec_R = R_without_fins-R_with_fins;
Q_without_fins = (Tw-Tinf)/(1/(h*Awall));
Q_with_fins = (Tw-Tinf)/(1/(h*((phi*Af)+Abare)));
inc_Rate = ((Q_with_fins-Q_without_fins)/Q_without_fins)*100;
end Ex9_20;
//The answer provided in the book is wrong
//The value of Awall had been substituted wrongly as 0.15 instead of 0.25 in the calculation of Bare area and the answers following it were wrong in the textbook
