model Ex9_21
//Parameter Section
parameter Real d(unit = "m") = 1.3*10^(-3) "Diameter of the glass rod";
parameter Real L(unit = "m") = 1 "Length of the glass rod";
parameter Real H(unit = "cal/g") = 79.7 "Heat of fusion of ice";
parameter Real K(unit = "W/m.K") = 0.86 "Thermal conductivity of glass";
parameter Real T1(unit = "C") = 110.6 "Temperature at one end"; //Normal boiling point of toluene
parameter Real T2(unit = "C") = 0 "Temperature at the other end"; //Freezing point of water
parameter Real t(unit = "min") = 60 "Time in minutes";
//================================================================================================
//Variable Section
Real A(unit = "m^2") "Cross sectional area of rod fo heat conduction";
Real Q(unit = "W") "Amount of heat transferred";
Real Q_thirty_min(unit = "cal") "Amount of heat transferred in 30 min";
Real m_ice(unit = "g") "Amount of ice melt in 30 min";
//================================================================================================
//Equation Section
equation 
A = (3.14*d^2)/4;
Q = (K*A*(T1-T2))/L; //Fourier's law of heat conduction
Q_thirty_min = (Q*30*60)/4.184; // 1 min = 60 sec and 1 cal = 4.184 J;
m_ice = Q_thirty_min/H;
end Ex9_21;
