model Ex9_7
//Parameter Section
parameter Real r(unit = "m") = 1.26*10^(-3) "Radius of the stainless steel wire";
parameter Real I(unit = "A") = 200 "Electric current";
parameter Real L(unit = "m") = 0.91 "Length of the wire";
parameter Real R(unit = "ohm") = 0.126 "Resistance offered by the wire";
parameter Real Tw(unit = "K") = 422.1 "Outer surface temperature of the wire";
parameter Real K(unit = "W/m.K") = 22.5 "Average thermal conductivity of the wire";
//===================================================================================
//Variable Section
Real P(unit = "W") "Power";
Real Se(unit = "W/m^3") "Heat generated per unit volume";
Real Tmax(unit = "K") "Centreline Temperature";
//===================================================================================
//Equation Section
equation
P = I^2*R;
Se = P/(3.14*r^2*L);
Tmax-Tw = ((Se*r^2)/(4*K));
end Ex9_7;
