model Ex9_9
//Parameter section
parameter Real Tmax(unit = "C") = 20 "Surface Temperature of the wire";
parameter Real T0(unit = "C") = 10 "Temperature rise at the wire";
parameter Real l(unit = "m") = 5 "Length of the copper wire";
parameter Real R(unit = "m") = 2*10^(-3) "Radius of the wire";
parameter Real L(unit = "volt^2/K^2") = 2.23*10^(-8) "Lorenz number for copper";
//================================================================================
//Variable Section
Real E(unit = "volt") "Voltage drop";
//================================================================================
//Equation Section
equation
E = ((2*l)*sqrt(L)*sqrt((T0+273)*(Tmax-T0)))/R;
end Ex9_9;
//The answer may slightly vary due to rounding off values
