model Ex11_4
//Parameter Section
parameter Real mu_f(unit = "N.s/m^2") = 1.94*10^(-5) "Viscosity of the fluid at 37.7 C";
parameter Real Cp_f(unit = "J/kg.K") = 1.0048*10^3 "Specific heat of the fluid at 37.7 C";
parameter Real K_f(unit = "W/m.K") = 0.027 "Thermal conductivity of the fluid at 37.7 C";
parameter Real rho_f(unit = "kg/m^3") = 1.137 "Density of the fluid at 37.7 C";
parameter Real V_inf(unit = "m/s") = 30.48 "Undisturbed air stream velocity";
parameter Real Tf(unit = "C") = 37.7 "Temperature of the fluid";
parameter Real Ts(unit = "C") = 93.33 "Temperature of the sphere";
parameter Real D(unit = "m") = 2.54*10^(-2) "Diameter of the sphere";
//=============================================================================================
//Variable Section
Real Re(unit = "nil") "Reynolds number";
Real Pr(unit = "nil") "Prandtl number";
Real h_m(unit = "W/m^2.K") "Heat transfer coefficient";
Real A(unit = "m^2") "Surface area of the sphere";
Real Q(unit = "W") "Rate of heat supplied to the sphere";
//=============================================================================================
//Equation Section
equation 
Re = (D*V_inf*rho_f)/mu_f;
Pr = (Cp_f*mu_f)/K_f;
(h_m*D)/K_f = 2+(0.6*Re^0.5*Pr^(1/3));
A = 3.14*D^2;
Q = h_m*A*(Ts-Tf); 
end Ex11_4;
