model Ex12_10
//Parameter Section
parameter Real D(unit = "ft") = 10 "Diameter of the mirror";
parameter Real e_output(unit = "hp") = 2 "Energy output from the device";
parameter Real solar_const(unit = "Btu/hr.ft^2") = 428 "Solar Constant";
//=========================================================================
//Variable Section
Real R(unit = "ft") "Radius of the mirror";
Real solar_constant(unit = "Btu/s") "Solar Constant in Btu/sec";
Real e_input(unit = "hp") "Energy input to the device";
Real eta(unit = "%") "Efficiency of the device";
//=========================================================================
//Equation Section
equation
R = D/2;
solar_constant = (solar_const*3.14*R^2)/3600; // 1 hr = 3600 s
e_input = (solar_constant*1055)/745; // Conversion factor 1 Btu = 1055 J and 1 hp = 745 W
eta = (e_output/e_input)*100;
end Ex12_10;
