model Ex12_11
//Parameter Section
parameter Real T1(unit = "C") = -196 "Temperature of the liquid nitrogen";
parameter Real T2(unit = "C") = 30 "Temperature of the spherical shell";
parameter Real D1(unit = "m") = 0.32 "Diameter of the spherical container";
parameter Real D2(unit = "m") = 0.36 "Diameter of the spherical shell";
parameter Real epsilon(unit = "nil") = 0.03 "Emissivities of both spheres"; //epsilon 1 = epsilon 2
parameter Real sigma(unit = "W/m^2.K^4") = 5.67*10^(-8) "Stefan-Boltzmann constant";
parameter Real lambda(unit = "kcal/kg") = 48 "Latent heat of vaporization of liquid nitrogen";
//===============================================================================================
//Variable Section 
Real A1(unit = "m^2") "Area of the spherical container";
Real A2(unit = "m^2") "Area of the spherical shell";
Real Q12(unit = "W") "Rate of heat transfer";
Real Q21(unit = "W") "Rate of heat transfer from spherical shell to container";
Real Rate(unit = "kg/s") "Rate at which nitrogen evaporates";
//Equation Section
equation
A1 = 3.14*D1^2;
A2 = 3.14*D2^2;
Q12 = (sigma*A1*((T1+273)^4-(T2+273)^4))/((1/epsilon)+((A1/A2)*((1/epsilon)-1)));
Q21 = -(Q12);
Rate = Q21/(lambda*10^3*4.184);// 1 cal =4.184 J 
end Ex12_11;
