model Ex12_2
//Parameter Section
parameter Real A(unit = "ft") = 3.14 "Area of the black discs";
parameter Real F12(unit = "nil") = 0.06 "Shape factor obtained from the graph";
parameter Real T1(unit = "R") = 2000 "Temperature of the disc 1";
parameter Real T2(unit = "R") = 1000 "Temperature of the disc 2";
parameter Real sigma(unit = "W/m^2.R^4") = 0.1712*10^(-8) "Stefan-Boltzmann constant";
//====================================================================================== 
//Variable Section
Real Q12(unit = "Btu/hr") "Heat flow between the two discs";
//======================================================================================
//Equation Section
equation 
Q12 = A*F12*sigma*(T1^4-T2^4);
end Ex12_2;
