model Ex12_6
//Parameter Section
parameter Real D(unit = "m") = 70*10^(-3) "Diameter of the steel tube";
parameter Real L(unit = "m") = 3 "Length of the steel tube";
parameter Real a(unit = "m") = 0.3 "Side of the square brick conduit";
parameter Real T1(unit = "C") = 227 "Temperature of the steel tube";
parameter Real T2(unit = "C") = 27 "Temperature of the square brick conduit";
parameter Real sigma(unit = "W/m^2.K^4") = 5.67*10^(-8) "Stefan-Boltzmann constant";
parameter Real epsilon_steel(unit = "nil") = 0.79 "Emissivity of the steel tube";
parameter Real epsilon_brick(unit = "nil") = 0.93 "Emissivity of the brick";
//=====================================================================================
//Variable Section
Real A1(unit = "m^2") "Area of the steel tube";
Real A2(unit = "m^2") "Area of the square brick conduit";
Real Q12(unit = "W") "Rate of heat transfer from the steel tube";
//=====================================================================================
//Equation Section
equation 
A1 = 3.14*D*L;
A2 = 4*a*L;
Q12 = (sigma*A1*((T1+273)^4-(T2+273)^4))/((1/epsilon_steel)+((A1/A2)*((1/epsilon_brick)-1)));
end Ex12_6;
//The answer may slightly vary due to rounding off values
