model Ex12_8
//Parameter Section
parameter Real D(unit = "m") = 2*10^(-2) "Diameter of the cylindrical electrical rod";
parameter Real T1(unit = "K") = 100 "Temperature of the rod";
parameter Real T2(unit = "K") = 800 "Temperature of the interior walls of the furnace";
parameter Real e(unit = "nil") = 0.9 "Emissivity of the rod";
parameter Real sigma(unit = "W/m^2.K^4") = 5.67*10^(-8) "Stefan-Boltzmann constant";
//========================================================================================
//Variable Section
Real q_per_L(unit = "W/m") "Rate of heat loss from the rod per unit length";
Real hr(unit = "W/m^2.K") "Radiation heat transfer coefficient";
//========================================================================================
//Equation Section
equation 
q_per_L = 3.14*D*e*sigma*(T1^4-T2^4);
hr = abs(q_per_L/(3.14*D*(T2-T1)));
end Ex12_8;
